const express = require('express');
const bodyParser = require('body-parser');
const axios = require('axios');
const { parseStringPromise } = require('xml2js');
const path = require('path');

const app = express();
const port = 3000;

app.use(bodyParser.json());

// سرو کردن فایل‌های استاتیک
app.use(express.static(path.join(__dirname, 'public')));

app.post('/api/payment', async (req, res) => {
    const { amount } = req.body;
    const requestData = {
        LoginAccount: '4Ycwq7fmmEJK084RC1Au', // این مقدار را با مقدار واقعی جایگزین کنید
        OrderId: Math.floor(Math.random() * 1000000000), // شناسه سفارش منحصربفرد
        Amount: amount,
        CallBackUrl: 'https://apitest.menuoff.com/callback', // آدرس بازگشت خود را وارد کنید
    };

    const xmlRequest = `
        <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:tem="http://tempuri.org/">
            <soapenv:Header/>
            <soapenv:Body>
                <tem:SalePayment>
                    <tem:requestData>
                        <tem:LoginAccount>${requestData.LoginAccount}</tem:LoginAccount>
                        <tem:OrderId>${requestData.OrderId}</tem:OrderId>
                        <tem:Amount>${requestData.Amount}</tem:Amount>
                        <tem:CallBackUrl>${requestData.CallBackUrl}</tem:CallBackUrl>
                    </tem:requestData>
                </tem:SalePayment>
            </soapenv:Body>
        </soapenv:Envelope>
    `;

    console.log("Request XML:");
    console.log(xmlRequest);

    try {
        const response = await axios.post(
            'https://pec.shaparak.ir/NewIPGServices/Sale/SaleService.asmx',
            xmlRequest,
            {
                headers: {
                    'Content-Type': 'text/xml; charset=utf-8',
                    // 'SOAPAction': 'http://tempuri.org/SalePayment'
                }
            }
        );

        console.log("Response from SOAP API:");
        console.log(response.data);

        const result = await parseStringPromise(response.data);
        res.json(result);
    } catch (error) {
        console.log("Error:");
        console.log(error.toString());
        res.status(500).send(error.toString());
    }
});

app.listen(port, () => {
    console.log(`Server is running on http://localhost:${port}`);
});
